function[pi34,pvalue] = Normality_pi34(data)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 1.8(c)
% File: Normality_pi34.m
%
% Bai-Ng (JBES, 2005) Normality test statistics ``pi34''.
%
% INPUT:  data
% OUTPUT: pi34, pvalue
%
% Reference:
% Bai, J. and Ng, S. (2005).
%   Tests for skewness, kurtosis, and normality for time series 
%   data.
%   Journal of Business & Economic Statistics, 23(1), 49-60.
%   DOI: 10.1198/073500104000000271.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
xx = data;
z  = xx-mean(xx);
n  = length(xx);
m2 = sum(z.*z)/(n-1);
m3 = sum(z.*z.*z)/(n-1);
m4 = sum(z.*z.*z.*z)/(n-1);
a  = zeros(2,4);
a(1,1) = -3*m2;
a(2,2) = -6*m2;
a(1,3) = 1.0;
a(2,4) = 1.0;
% Start computing test statistic for normality: 
vv = [z,(z.*z-m2), z.*z.*z, (z.*z.*z.*z-3*m2^2)];
[nsize,nreg] = size(vv);

% Find the LS approximation solution with the QR decomposition
for i = 1:nreg
    A = vv(2:nsize,i);
    y = vv(1:nsize-1,i);
    if issparse(A), R = qr(A);
       else R = triu(qr(A));
    end;
    be(i)   = R\(R'\(A'*y));
    r       = y-A*be(i);
    rrr     = r'*r/nsize;
    se_b(i) = rrr;
end

beta = zeros(nreg,nreg);
bot  = 0; top = 0;
for i = 1:nreg
    top = top+4*(be(i)^2)*se_b(i)^2/(1-be(i))^8;  
    bot = bot+se_b(i)^2/((1-be(i))^4);
end
alpha = top/bot;
k = ceil(2.6614*(alpha*nsize)^(0.2));  
if k > n/2; k = n/2;
end

% Variance-covariance matrix 
vcv = vv'*vv/(n-1);
for i = 1:k
    x = i/k;
    if abs(x) >= 0 && abs(x) <= .5;   % Weights Parzen window 
       w = 1-6*(abs(x))^2+6*abs(x)^3;
    else
       w = 2*(1-abs(x))^3;
    end;  
    cov = vv(i+1:nsize,:)'*vv(1:nsize-i,:)/(n-1);
    vcv = vcv+w*cov;
    cov = vv(1:nsize-i,:)'*vv(i+1:nsize,:)/(n-1);
    vcv = vcv+w*cov;
end
d      = inv(eye(nreg)-beta');
omega  = d*vcv*d'; 
se     = a*omega*a';
stat   = [m3,(m4-3*m2^2)]';
pi34   = stat'*inv(se)*stat*n; % end computing normality test 
pvalue = 1-chi2cdf(pi34,2);
